//////////
//
//	File:		QTVRUtilities.h
//
//	Contains:	Some utilities for working with QuickTime and QuickTime VR movies.
//				All utilities start with the prefix "QTVRUtils_".
//
//	Written by:	Tim Monroe
//
//	Copyright:	 1996-1997 by Apple Computer, Inc., all rights reserved.
//
//	Change History (most recent first):
//
//	   <2>	 	01/27/97	rtm		added some constants
//	   <1>	 	11/27/96	rtm		first file
//	   
//////////

#pragma once

// header files

#ifndef __QTVRUtilities__
#define __QTVRUtilities__

#ifndef __MOVIES__
#include <Movies.h>
#endif

#ifndef __QUICKTIMEVR__
#include <QuickTimeVR.h>
#endif

#ifndef __QUICKTIMEVRFORMAT__
#include <QuickTimeVRFormat.h>
#endif

#ifndef __TRAPS__
#include <Traps.h>
#endif

#ifndef __GESTALT__
#include <Gestalt.h>
#endif

#ifndef __Prefix_File__
#include "WinPrefix.h"
#endif

#include <Endian.h>
#include "QD3D.h"

// constants

enum {
	kQTVRSpeakerButton 		= mcFlagSuppressSpeakerButton,
	kQTVRBackButton 		= mcFlagQTVRSuppressBackBtn,
	kQTVRZoomButtons 		= mcFlagQTVRSuppressZoomBtns,
	kQTVRHotSpotButton 		= mcFlagQTVRSuppressHotSpotBtn,
	kQTVRTranslateButton 	= mcFlagQTVRSuppressTranslateBtn,
	kQTVRHelpText 			= mcFlagQTVRSuppressHelpText,
	kQTVRHotSpotNames 		= mcFlagQTVRSuppressHotSpotNames,
	kQTVRCustomButton 		= mcFlagsUseCustomButton
};

// values of 
#define kVRPi 					((float)3.1415926535898)
#define kVR2Pi 					((float)(2.0 * 3.1415926535898))
#define kVRPiOver2				((float)(3.1415926535898 / 2.0))
#define kVR3PiOver2				((float)(3.0 * 3.1415926535898 / 2.0))

// define a constant for an invalid hot spot ID;
// hot spot IDs are just indices into an 8-bit palette, so valid IDs range from 0 to 255
#define kQTVRUtils_InvalidHotSpotID				(UInt32)-1


//////////
//
// QTVRUtils_DegreesToRadians
// QTVRUtils_RadiansToDegrees
// Angle conversion utilities.
//
//////////

#define QTVRUtils_DegreesToRadians(x)			((float)((x) * kVRPi / 180.0))
#define QTVRUtils_RadiansToDegrees(x)			((float)((x) * 180.0 / kVRPi))

// some other define'd symbols
#define QTVRUtils_GetDistance(thePoint)			sqrt((thePoint.x*thePoint.x)+(thePoint.y*thePoint.y)+(thePoint.z*thePoint.z))

// function prototypes

Boolean						QTVRUtils_TrapAvailable (short theTrapWord);
Boolean						QTVRUtils_IsQTVRMgrInstalled (void);
long						QTVRUtils_GetQTVRVersion (void);
OSType						QTVRUtils_GetControllerType (Movie theMovie);
OSErr						QTVRUtils_SetControllerType (Movie theMovie, OSType theType);
Boolean						QTVRUtils_IsQTVRMovie (Movie theMovie);
Boolean						QTVRUtils_Is20QTVRMovie (Movie theMovie);
Boolean						QTVRUtils_IsTranslateAvailable (QTVRInstance theInstance);
Boolean						QTVRUtils_IsZoomAvailable (QTVRInstance theInstance);
Boolean						QTVRUtils_IsPanoNode (QTVRInstance theInstance);
Boolean						QTVRUtils_IsObjectNode (QTVRInstance theInstance);
Boolean						QTVRUtils_IsHotSpotInNode (QTVRInstance theInstance);
Boolean						QTVRUtils_IsMultiNode (QTVRInstance theInstance);
Boolean						QTVRUtils_IsControllerBarVisible (MovieController theMC); 
short						QTVRUtils_GetControllerBarHeight (MovieController theMC);
void						QTVRUtils_HideControllerBar (MovieController theMC);
void						QTVRUtils_ShowControllerBar (MovieController theMC);
void						QTVRUtils_ToggleControllerBar (MovieController theMC);
void						QTVRUtils_HideControllerButton (MovieController theMC, long theButton); 
void						QTVRUtils_ShowControllerButton (MovieController theMC, long theButton); 
void						QTVRUtils_ToggleControllerButton (MovieController theMC, long theButton);
void						QTVRUtils_ResetControllerButton (MovieController theMC, long theButton);
Boolean						QTVRUtils_IsControllerButtonVisible (MovieController theMC, long theButton);
void						QTVRUtils_HideHotSpotNames (MovieController theMC);
void						QTVRUtils_ShowHotSpotNames (MovieController theMC);
void						QTVRUtils_ToggleHotSpotNames (MovieController theMC);
OSErr						QTVRUtils_GetVRWorldHeaderAtomData (QTVRInstance theInstance, QTVRWorldHeaderAtomPtr theVRWorldHdrAtomPtr);
OSErr						QTVRUtils_GetNodeHeaderAtomData (QTVRInstance theInstance, UInt32 theNodeID, QTVRNodeHeaderAtomPtr theNodeHdrPtr);
OSErr						QTVRUtils_GetHotSpotAtomData (QTVRInstance theInstance, UInt32 theNodeID, UInt32 theHotSpotID, QTVRHotSpotInfoAtomPtr theHotSpotInfoPtr);
char *						QTVRUtils_GetStringFromAtom (QTAtomContainer theContainer, QTAtom theParent, QTAtomID theID);
OSErr						QTVRUtils_AddStr255ToAtomContainer (QTAtomContainer theContainer, QTAtom theParent, Str255 theString, QTAtomID *theID);
UInt32						QTVRUtils_GetDefaultNodeID (QTVRInstance theInstance);
UInt32						QTVRUtils_GetSceneFlags (QTVRInstance theInstance);
char *						QTVRUtils_GetSceneName (QTVRInstance theInstance);
UInt32						QTVRUtils_GetNodeCount (QTVRInstance theInstance);
OSErr						QTVRUtils_GetNodeType (QTVRInstance theInstance, UInt32 theNodeID, OSType *theNodeType);
char *						QTVRUtils_GetNodeName (QTVRInstance theInstance, UInt32 theNodeID);
char *						QTVRUtils_GetNodeComment (QTVRInstance theInstance, UInt32 theNodeID);
UInt32						QTVRUtils_GetHotSpotCount (QTVRInstance theInstance, UInt32 theNodeID, Handle theHotSpotIDs);
UInt32						QTVRUtils_GetHotSpotIDByIndex (QTVRInstance theInstance, Handle theHotSpotIDs, UInt32 theIndex);
OSErr						QTVRUtils_GetHotSpotType (QTVRInstance theInstance, UInt32 theNodeID, UInt32 theHotSpotID, OSType *theHotSpotType);
char *						QTVRUtils_GetHotSpotName (QTVRInstance theInstance, UInt32 theNodeID, UInt32 theHotSpotID);
float						QTVRUtils_Point3DToPanAngle (float theX, float theY, float theZ);
float						QTVRUtils_Point3DToTiltAngle (float theX, float theY, float theZ);
PASCAL_RTN OSErr			QTVRUtils_StandardEnteringNodeProc (QTVRInstance theInstance, long theNodeID, MovieController theMC);
PASCAL_RTN OSErr			QTVRUtils_StandardLeavingNodeProc (QTVRInstance theInstance, long fromNodeID, long toNodeID, Boolean *theCancel, MovieController theMC);


#endif	// ifndef __QTVRUtilities__